from typing import Any, List
from pipelines.prompta.oracle.base_llm_oracle import BaseLLMOracle
from pipelines.prompta.utils import get_value_by_key
from prompta.core.language import BaseLanguage


class LLMJSOracle(BaseLLMOracle):
    def __init__(
        self,
        language: BaseLanguage,
        model_name: str,
        task_name: str,
        *args: Any,
        **kwargs: Any
    ) -> None:
        self.task_name = task_name
        self._setup_language_alphabet(language)
        super().__init__(language, *args, **kwargs)

    def _construct_existence_message(self, query: List[str]):
        return [
            {"role": "system", "content": "You are a helpful assistant designed to output JSON. Answer in a consistent style."},
            {"role": "user", "content": f"{self.language.definition} Given a sequence of mineflayer API's \"{query}\", does this sequence belongs to the language?"}
        ]

    def _setup_language_alphabet(self, language: BaseLanguage):
        example = "{\"answer\": ['placeItem', 'craftItem']}"
        query = [
            {"role": "system", "content": "You are a helpful assistant designed to output JSON. Answer in a consistent style."},
            {"role": "user", "content": f"Here are the most common API's of mineflayer {language.base_alphabet}. To write a script to complete a task {self.task_name} in Minecraft, tell me what might be useful for this script. Sort them into a list of your JSON response, like {example}. You can add other API's not in the list. Assume the player already have all the items to craft a certain item in their inventory. However, the corresponding tool to mine a certain block may not be in their inventory and needs to be checked." }
        ]
        result = self._get_json_resp(query, max_tokens=1000)
        ans = get_value_by_key(result, "answer")
        if ans is None:
            print(result)
            ans = []
            for k in result:
                ans += k
        language.set_alphabet(ans)


    
